<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use Twilio\Rest\Client;

class Twilio {

    private $ci;

    public function __construct() {
        $this->ci =& get_instance();
        $this->ci->config->load('twilio');
    }

    public function sms($to, $body) {
        $sid = $this->ci->config->item('twilio_sid');
        $token = $this->ci->config->item('twilio_token');

        $client = new Client($sid, $token);

        $message = $client->messages->create(
            $to,
            array(
                'from' => $this->ci->config->item('twilio_whatsapp_number'),
                'body' => $body
            )
        );

        return $message->sid;
    }
}
